import { closeAllMenues, getElement, slideDown, slideUp, fadeIn, fadeOut } from "./utils.js";

const activateMenu = (deviceType, deviceSize) => {
    const menu = getElement('.main_menu');
    const headerDropBtn = getElement('.header_top .actions_list');
    let openedSubs, menuDelayTime = null;
    const menuItem = menu.children;
    const burgerBtn = document.querySelector('.menu_btn');
    // const activeMenu = menu.querySelector('.opened') ?  menu.querySelector('.opened') : null;
    const subBtnClassName = 'submenu_btn';

    const closeOpenedSubs = ($sub) => {
        for (let i = 0; i < $sub.length; i++) {
            $sub[i].classList.remove('opened');
            if(window.innerWidth > deviceSize) {
                fadeOut($sub[i].querySelector('.submenu_list'));
            } else {
                slideUp($sub[i].querySelector('.submenu_list'));
            }
        }
    }

    const mouseLeaveItem = (e) => {

        let current = e.target;
        if(!deviceType && current.parentNode.querySelectorAll('.hovered').length > 0) {
            for(let i = 0; i < current.parentNode.querySelectorAll('.hovered').length; i++) {
                current.parentNode.querySelectorAll('.hovered')[i].classList.remove('hovered');
            }
      
        }      
    }

    const togglemobileMenu = () => {
        if (body.classList.contains('menu_opened')) {
            body.classList.remove('menu_opened');
        } else {
            openedSubs = menu.querySelectorAll('.opened').length > 0 ? menu.querySelectorAll('.opened') : null;
            if(openedSubs) {
                closeOpenedSubs(openedSubs);
                openedSubs = null;
            }
            // $('.submenu_list').hide();
            // $('.menu_inner, body, html').animate({scrollTop: 0},0);
            body.classList.add('menu_opened');
        }
    };

    const openSubWithClick = (evt) => {
        evt.preventDefault();
        const subBtn = evt.target;
        const subParent = subBtn.closest('li');
        const parentList = subBtn.closest('ul');
        const subMenu = subParent.querySelector('.submenu_list');
        const allSubs = parentList.querySelector('.submenu_list');
        
        if(deviceType && window.innerWidth > deviceSize) {
            evt.preventDefault();
            evt.stopPropagation();
            if (subParent.classList.contains('opened')) {
                subParent.classList.remove('opened');
                slideUp(subMenu);
            } else {
                openedSubs = parentList.querySelectorAll('.opened').length > 0 ? parentList.querySelectorAll('.opened') : null;
                if(openedSubs) {
                    closeOpenedSubs(openedSubs);
                };
                
                subParent.classList.add('opened');
                openedSubs = menu.querySelectorAll('.opened');
                slideDown(subMenu);
                
                
            }
        } else if (window.innerWidth <= deviceSize) {
            if (subParent.classList.contains('opened')) {
                subParent.classList.remove('opened')
                slideUp(subMenu);
            } else {
                openedSub.classList.remove('opened');
                slideUp(allSubs);
                subParent.classList.add('opened')
                slideDown(subMenu);
            }
        }
        
        // if(isTouchDevice() && window.innerWidth > $mobileSize) {
        //     if($('.main_menu .opened').length < 1) {
        //         closeAllMenues(evt);
        //     };
        //     evt.stopPropagation();
        //     if (subParent.classList.contains('opened')) {
        //         subParent.classList.remove('opened').children('.submenu_list').slideUp(300);
        //     } else {
        //         $this.closest('ul').find('.opened').classList.remove('opened');
        //         $this.closest('ul').find('.submenu_list').fadeOut(300);
        //         subParent.classList.add('opened').children('.submenu_list').stop(true,true).slideDown(300);
        //     }
            
        
    }

    const openSubWithHover = (evt) => {
        if (!deviceType && window.innerWidth > deviceSize) {
            if(menuDelayTime) {
                clearTimeout(menuDelayTime);
            };
            let subBtn = evt.target;
            let subParent = subBtn.closest('li');
            let subParentList = subParent.closest('ul');
            if(subParentList.querySelectorAll('.opened').length > 0) {
                closeOpenedSubs(subParentList.querySelectorAll('.opened'))
            }
            subParent.classList.add('hovered');
            menuDelayTime = setTimeout(() =>{
                if (subParent.classList.contains('hovered')) {
                    subParent.classList.add('opened')
                    slideDown(subParent.querySelector('.submenu_list'));
                }
            },300)
        };
    }

    const closeAllSubs = () => {
        if(menu.querySelectorAll('.hovered').length > 0) {
            for(let i = 0; i < menu.querySelectorAll('.hovered').length; i++) {
                menu.querySelectorAll('.hovered')[i].classList.remove('hovered');
            }
        };
        if(menu.querySelectorAll('.opened').length > 0) {
            closeOpenedSubs(menu.querySelectorAll('.opened'));
        }
    }

    const showDropBlock = (evt) => {
        if(evt.target.classList.contains('drop_btn') || evt.target.parentNode.classList.contains('drop_btn')) {
            const dropParent = evt.target.closest('div');
            const dropElement = dropParent.querySelector('.drop_list');
            if(!dropParent.classList.contains('opened')) {
                closeAllMenues(evt);
                evt.stopPropagation();
                dropParent.classList.add('opened');
                slideDown(dropElement);
            }
        }
    }



    // burgerBtn.addEventListener('click', togglemobileMenu);
    // menu.onClick(subBtnClassName, openSubWithClick);
    // menu.onHover(subBtnClassName, openSubWithHover);
    // menu.onHover('li', mouseLeaveItem);
    // menu.unHover(closeAllSubs);

    
    headerDropBtn.onClick(showDropBlock);
}

export {
    activateMenu
}