//click function
let slideEnd, fadeEnd = null;
const getElement = (selector) => {

    const elem = document.querySelector(selector);

    const attachedElem = Object.assign(elem, {
        onClick: function(callback) {
            this.addEventListener('click', (e) => {
				callback(e);
			});
        },
		onHover: function(callback) {
			this.addEventListener('mouseover', (e) => {
					callback(e);
			});
		},
		unHover: function(callback) {
			this.addEventListener('mouseleave', (e) => {
				callback(e);
			})
		}
    })
	return attachedElem;
}

const resetStyles = ($element, duration, position, display = null) => {
	if(slideEnd) {
		clearTimeout(slideEnd);
	}
	slideEnd = setTimeout(() => {
		$element.style.height = null;
		$element.style.overflow = null;
		$element.style.transition = null;
		if(!display) {
			$element.style.display = null;
			$element.removeAttribute('data-height');
		};
        if(position) {
            $element.style.position = null
        }
		clearTimeout(slideEnd);
	}, duration);
}

const slideDown = ($element, duration = 300, type = 'ease-in-out', blockType = 'block') => {
	$element.style.display = blockType;
	let blockHeight = $element.getAttribute('data-height') ? parseInt($element.getAttribute('data-height')) : parseFloat(window.getComputedStyle($element).height);
	if(!$element.getAttribute('data-height')) {
		$element.setAttribute('data-height', blockHeight);
	}
	let position = window.getComputedStyle($element).position == 'static' ? 'relative' : null;

	$element.style.height = 0;
	$element.style.transition = 'height ' + duration + 'ms ' + type; 
	position ? $element.style.position = position : '';
	$element.style.overflow = 'hidden';

	setTimeout(()=> {
		$element.style.height = blockHeight + 'px';
		resetStyles($element, duration, position, blockType);
	},0);
}

const slideUp = ($element, duration = 300, type = 'ease-in-out') => {
	let blockHeight = parseFloat(window.getComputedStyle($element).height);
	let position = window.getComputedStyle($element).position == 'static' ? 'relative' : null;
	
	$element.style.height = blockHeight + 'px';
	position ? $element.style.position = position : '';
	$element.style.overflow = 'hidden';
	$element.style.transition = 'height ' + duration + 'ms ' + type; 

	setTimeout(()=> {
		$element.style.height = 0 + 'px';
		resetStyles($element, duration, position);
		
	},0);
}

const finishFade = ($element, duration, $display = null) => {
	if(fadeEnd) {
		clearTimeout(fadeEnd);
	};
	fadeEnd = setTimeout(() => {
		$element.style.opacity = null;
		$element.style.transition = null;
		$element.style.overflow = null;
        if(!$display) {
            $element.style.display = null;
        }
		clearTimeout(fadeEnd);
	}, duration);
}

const fadeIn = ($element, duration = 300, type = 'ease-in-out', blockType = 'block') => {
	$element.style.display = blockType;
	// let position = window.getComputedStyle($element).position == 'static' ? 'relative' : null;

	$element.style.opacity = 0;
	$element.style.transition = 'opacity ' + duration + 'ms ' + type; 
	// position ? $element.style.position = position : '';
	$element.style.overflow = 'hidden';

	setTimeout(()=> {
		$element.style.opacity = 1;
		finishFade($element, duration, blockType);
	},0);
}

const fadeOut = ($element, duration = 300, type = 'ease-in-out') => {
	// let position = window.getComputedStyle($element).position == 'static' ? 'relative' : null;
	
	// position ? $element.style.position = position : '';
	$element.style.overflow = 'hidden';
	$element.style.transition = 'opacity ' + duration + 'ms ' + type; 

	setTimeout(()=> {
		$element.style.opacity = 0;
		finishFade($element, duration);
	},0);
}

const closeAllMenues = (evt) => {
	
	if(document.querySelectorAll('.drop_block.opened').length > 0 && !evt.target.closest('.drop_list')) {
		slideUp(document.querySelector('.drop_block.opened .drop_list'));
		document.querySelector('.drop_block.opened').classList.remove('opened');
	}
}

const comboHover = ($element, $block) => {
	const hoveredEl = getElement($element);
	const comboMouseOver = (e) => {
		if(e.target.tagName.toLowerCase() === 'a' || e.target.parentNode.tagName.toLowerCase() === 'a') {
			e.target.closest($block).classList.add('hovered');
		} else {
			comboMouseLeave();
		}
	}

	const comboMouseLeave = () => {
		if(document.querySelectorAll('.hovered').length > 0) {
			document.querySelectorAll($block).forEach((item) => {
				item.classList.remove('hovered');
			})
		}
	}

    hoveredEl.onHover(comboMouseOver);
    hoveredEl.unHover(comboMouseLeave);
}


//detecting document ready state
const docReady = (fn) => {
    if (document.readyState === "complete" || document.readyState === "interactive") {
        setTimeout(fn, 1);
    } else {
        document.addEventListener("DOMContentLoaded", fn);
    }
} 

export {
	resetStyles,
	slideDown,
	slideUp,
	fadeIn,
	fadeOut,
	getElement,
	docReady,
	comboHover,
	closeAllMenues
}