import { activateMenu } from "./imports/header.js";
import { closeAllMenues, getElement } from "./imports/utils.js";

const body = getElement('body'); //body
const html = getElement('html'); //html

const $mobileSize = 1024; 

//web/touch detect function
const isTouchDevice = () => {
	return 'ontouchstart' in document.documentElement;
};

//viewport meta change function for ios devices during touch and focusout fields with small font sizes
const changeIosMeta = () => {
	const fields = document.querySelectorAll('input, textarea');
	if(body.classList.contains('ios_device') && fields.length > 0) {
		
		const viewPortMeta = document.querySelector('meta[name="viewport"]'); //viewport meta
		const standardMeta = "width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"; //viewport meta content standard value
		const unScaleMeta = "width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0, viewport-fit=cover"; //viewport meta content unscaleable value for ios devices with fields with small font sizes
		let metaChange = false; //meta content value change indicator

		fields.forEach((field) => {
			const fieldFontSize = parseFloat(window.getComputedStyle(field).fontSize);
			if (fieldFontSize < 16) {
				field.addEventListener('touchstart', () => {
					viewPortMeta.content = unScaleMeta;
					metaChange = true;
				});
			}
		})  

		fields.forEach((field) => {
			field.addEventListener('focusout', () => {
				if(metaChange) {
					viewPortMeta.content = standardMeta;
					metaChange = false;
				}
			})
		})
	}
}

// device type and ios detect function;
const detectDevice = () => {

	//detect ios device or not
	if(navigator.userAgent.search("Safari") >= 0 && navigator.userAgent.search("Chrome") < 0) {
		body.classList.add('ios_device');       
	};	 

	//detect touch device or not
	if(isTouchDevice()) {
		html.classList.add('touch');

		changeIosMeta();
		
	} else {
		html.classList.add('web');
	}
}

//device call posibillity detect function
const detectCallPosibillity = () => {
	const phoneLink = document.querySelectorAll('[href*="tel:"]');
	if(phoneLink.length > 0 && !/Android|iPhone|iPad|iPod|BlackBerry|BB|PlayBook|IEMobile|Windows Phone|Kindle|Silk|Opera Mini/i.test(navigator.userAgent)) {
		phoneLink.forEach((link,index) => {
			link.removeAttribute('href');
		})
	}
}

const detectContentHeight = () => {
	let footerHeight = document.querySelectorAll('.footer').length > 0 ? parseFloat(window.getComputedStyle(document.querySelector('.footer')).height) : 0;
	let headerHeight = document.querySelectorAll('.header').length > 0  && document.querySelector('.header').style.position != 'fixed' ? parseFloat(window.getComputedStyle(document.querySelector('.header')).height) : 0;
	
	let freeSpace = window.innerHeight - Math.round(footerHeight) - Math.round(headerHeight) - 1;
	if (freeSpace > 0) {
		document.querySelector('.content').style.minHeight = freeSpace + 'px';
	} else {
		document.querySelector('.content').style.minHeight = null;
	};
	document.querySelector('.footer').style.opacity = 1;
}

//group all global functions in one function for exporting
const initGlobalFunctions = () => {
	detectDevice();
	detectCallPosibillity();

	activateMenu(isTouchDevice(), $mobileSize);

	body.onClick(closeAllMenues);

}

export {
	initGlobalFunctions,
	detectContentHeight
}