<!DOCTYPE HTML>
<html lang="hy">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <meta name="format-detection" content="telephone=no"/>
    <meta name="description" content="some description about project">
    <title>Forte Piano</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/select.css">
    <link rel="stylesheet" href="css/contact/contact.css">
    <link rel="stylesheet" media="screen and (min-width: 1025px)" href="css/contact/contact-l.css">
    <link rel="stylesheet" media="screen and (max-width: 1024px)" href="css/contact/contact-m.css">
    <?php
    include 'templates/favicons.php'
    ?>
</head>
<body>
<div class="page-wrapper">
    <?php
    include 'templates/header.php'
    ?>
    <div class="breadcrumbs">
        <a href="" class="back_btn icon_left">Контакты</a>
        <ul class="items">
            <li class="item home">
                <a href="index.php" title="Go to Home Page">главная страница</a>
            </li>
            <li class="item">
                <strong>Контакты</strong>
            </li>
        </ul>
    </div>
    <main id="maincontent" class="page-main">
        <div class="top_image">
            <div class="image_inner">
                <img src="images/contact.webp" alt="" title="" width="1920" height="580" />
            </div>
        </div>
        <div class="page-title-wrapper">
            <h1 class="page-title">
                <span class="base" data-ui-id="page-title-wrapper">Контакты</span>
            </h1>
        </div>
        <div class="columns">
            <div class="column main">
                <div class="widget block block-static-block">
                    <div class="contact-info cms-content">
                        <div class="block block-contact-info">
                            <div class="block-title">
                                <strong>Contact Us Info</strong>
                            </div>
                            <div class="block-content">
                                <div class="box box-telephone">
                                    <strong class="box-title">
                                        <span>Позвоните нам</span>
                                    </strong>
                                    <div class="box-content">
                                        <p><a href="tel:+475654784984934" class="phone_link">+475654784984934</a></p>
                                    </div>
                                </div>
                                <div class="box box-email">
                                    <strong class="box-title">
                                        <span>Напишите email</span>
                                    </strong>
                                    <div class="box-content">
                                        <p><a href="mailto:bechstein.info@gmail.com">bechstein.info@gmail.com</a></p>
                                    </div>
                                </div>
                                <div class="box box-address">
                                    <strong class="box-title">
                                        <span>Офисы</span>
                                    </strong>
                                    <div class="box-content">
                                        <p>12/4 Azatutyan Ave. Apt. 24, Yerevan 0037, Armenia</p>
                                    </div>
                                </div>
                                <div class="box box-social">
                                    <strong class="box-title">
                                        <span>social media</span>
                                    </strong>
                                    <div class="box-content">
                                        <ul class="socials_list">
                                            <li><a href="" class="icon_facebook" target="_blank">facebook</a></li>
                                            <li><a href="" class="icon_linkedin" target="_blank">linkedin</a></li>
                                            <li><a href="" class="icon_instagram" target="_blank">instagram</a></li>
                                            <li><a href="" class="icon_x" target="_blank">instagram</a></li>
                                            <li><a href="" class="icon_telegram" target="_blank">telegram</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="contacts_section">
                                <form class="form contact" id="contact-form">
                                    <fieldset class="fieldset">
                                        <legend class="legend"><span>Ваше сообщение для нас</span></legend>
                                        <br/>
                                        <div class="description_block">
                                            Как правило, мы сами обрабатываем поступающие запросы. В особых случаях ваш
                                            запрос будет перенаправлен на обработку импортёру в вашей стране или
                                            авторизованным партнёрам компании «К. Бехштейн» в вашем регионе.
                                        </div>
                                        <div class="field note no-label">
                                            Jot us a note and we’ll get back to you as quickly as possible.
                                        </div>
                                        <div class="field name required">
                                            <label class="label" for="name"><span>Имя</span></label>
                                            <div class="control">
                                                <input name="name" id="name" placeholder="Имя" value=""
                                                       class="input-text" type="text"/>
                                            </div>
                                        </div>
                                        <div class="field name required">
                                            <label class="label" for="name"><span>Фамилия</span></label>
                                            <div class="control">
                                                <input name="name" id="name" placeholder="Фамилия" value=""
                                                       class="input-text" type="text"/>
                                            </div>
                                        </div>
                                        <div class="field email required">
                                            <label class="label"
                                                   for="email"><span>Адрес электронной почты*</span></label>
                                            <div class="control">
                                                <input name="email" id="email" placeholder="Адрес электронной почты*"
                                                       value="" class="input-text" type="email"/>
                                            </div>
                                        </div>
                                        <div class="field _required">
                                            <label class="label" for="subject">
                                                <span>Country</span>
                                            </label>
                                            <div class="control">
                                                <select class="select select_hash" name="name" id="subject"
                                                        data-noresult="Чем можем вам помочь?*">
                                                    <option value="">Чем можем вам помочь?*</option>
                                                    <option>1</option>
                                                    <option>2</option>
                                                    <option>3</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="field comment required">
                                            <label class="label" for="comment">
                                                <span>Сообщение*</span>
                                            </label>
                                            <div class="control">
                                                <textarea name="comment" id="comment" placeholder="Сообщение*"
                                                          class="input-text" cols="5" rows="3"></textarea>
                                            </div>
                                        </div>
                                    </fieldset>
                                    <div class="create-account-checkbox field choice ">
                                        <input type="checkbox" name="create-account-checkbox"
                                               id="create-account-checkbox"/>
                                        <label for="create-account-checkbox">
                                            <span>Да, я прочитал(а) заявление о согласии и даю согласие на хранение и использование моих персональных данных.</span>
                                        </label>
                                    </div>
                                    <div class="actions-toolbar">
                                        <div class="primary">
                                            <input type="hidden" name="hideit" id="hideit" value="" />
                                            <button type="submit" aria-label="Отправить" class="action submit primary">
                                                <span>Отправить</span>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="box box-map">
                                <strong class="box-title">
                                    <span>view on map</span>
                                </strong>
                                <div class="box-content">
                                    <div class="map_block" style="position:relative;overflow:hidden;">
                                        <a href="https://yandex.ru/maps/-/CHU7r-MH/?utm_medium=mapframe&utm_source=maps"
                                           style="color:#eee;font-size:12px;position:absolute;top:0px;">Ереван</a>
                                        <a href="https://yandex.ru/maps/-/CHU7r-MH&utm_medium=mapframe&utm_source=maps&z=16"
                                           style="color:#eee;font-size:12px;position:absolute;top:14px;">Яндекс Карты —
                                            транспорт, навигация, поиск мест</a>
                                        <iframe src="https://yandex.ru/map-widget/v1/-/CHU7r-MH?lang=en_RU&z=16&theme=dark"
                                                width="100%" height="600" frameborder="1" allowfullscreen="true"
                                                style="position:relative;"></iframe>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'templates/footer.php'
    ?>
</div>

<script src="js/jquery-3.7.1.min.js"></script>
<script src="js/select2.min.js"></script>
<script src="js/magentoMenu.js"></script>
<script src="js/main.js"></script>
</body>
</html>