<!DOCTYPE HTML>
<html lang="hy">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <meta name="format-detection" content="telephone=no"/>
    <meta name="description" content="some description about project">
    <title>Forte Piano</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/home/index.css">
    <link rel="stylesheet" media="screen and (min-width: 1025px)" href="css/home/index-l.css">
    <link rel="stylesheet" media="screen and (max-width: 1024px)" href="css/home/index-m.css">
    <?php
    include 'templates/favicons.php'
    ?>
</head>
<body>
<div class="page-wrapper home_page">
    <?php
    include 'templates/header.php'
    ?>

    <main id="maincontent" class="page-main">
        <div class="columns">
            <div class="column main">
                <div class="widget block block-static-block">
                    <div class="block_promo">
                        <div class="main_slider">
                            <div class="slider_inner">
                                <div class="slide_block">
                                    <div class="slide_image">
                                        <picture>
                                            <source media="(min-width:1441px)" width="1920" height="1080" srcset="images/main_screen_mob@x2.webp 1x, images/main_screen_web@jpg.webp 2x">
                                            <source media="(min-width:1025px)" width="1440" height="810" srcset="images/main_screen_mob@x2.webp 1x, images/main_screen_web@jpg.webp 2x">
                                            <source media="(min-width:769px)" width="1024" height="576" srcset="images/main_screen_mob@x2.webp 1x, images/main_screen_web@jpg.webp 2x">
                                            <source media="(min-width:480px)" width="768" height="1024" srcset="images/mobile.webp"> <!--size x2-->
                                            <img class="full_height" src="images/mobile.webp" width="360" height="640" alt="" title=""/> <!--size x2-->
                                        </picture>
                                    </div>
                                    <div class="slide_info">
                                        <div class="info_inner">
                                            <div class="slide_title">Компания «Бехштейн» приветствует вас!</div>
                                            <div class="slide_desc">Марка C. Bechstein сегодня предстаёт в новом блеске!
                                                Фортепианная мануфактура C. Bechstein,
                                            </div>
                                            <a href="" class="slide_btn">все О нас</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="slide_block">
                                    <div class="slide_image">
                                        <picture>
                                            <source media="(min-width:1441px)" width="1920" height="1080" srcset="images/main_screen2.webp 1x, images/main_screen2.webp 2x">
                                            <source media="(min-width:1025px)" width="1440" height="810" srcset="images/main_screen2.webp 1x, images/main_screen2.webp 2x">
                                            <source media="(min-width:769px)" width="1024" height="576" srcset="images/main_screen2.webp 1x, images/main_screen2.webp 2x">
                                            <source media="(min-width:480px)" width="768" height="1024" srcset="images/main_screen2.webp"> <!--size x2-->
                                            <img class="full_height" src="images/main_screen2.webp" width="360" height="640" alt="" title=""/> <!--size x2-->
                                        </picture>
                                    </div>
                                    <div class="slide_info">
                                        <div class="info_inner">
                                            <div class="slide_title">Компания «Бехштейн» </div>
                                            <div class="slide_desc">Марка C. Bechstein сегодня предстаёт
                                            </div>
                                            <a href="" class="slide_btn">все О нас</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="slider_indicator">
                                <div class="indicator_inner">
                                    <span class="current_slide">1</span>/<span class="slides_count"></span>
                                    <span class="indicator_line"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="products_section">
                    <div class="section_head">
                        <h2 class="section_title">Топ продукция</h2>
                        <a href="listing.php" class="view_more">просмотреть все</a>
                    </div>
                    <div class="products_slider">
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>

                    </div>
                </div>
                <div class="brands_section">
                    <div class="section_head">
                        <h2 class="section_title">Бренды</h2>
                    </div>
                    <div class="brands_slider">
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo1.webp"
                                     srcset="images/brand_logo1.webp 1x,
												images/brand_logo1.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                                name
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo2.webp"
                                     srcset="images/brand_logo2.webp 1x,
												images/brand_logo2.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                                name
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo3.webp"
                                     srcset="images/brand_logo3.webp 1x,
												images/brand_logo3.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                                name
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo1.webp"
                                     srcset="images/brand_logo1.webp 1x,
												images/brand_logo1.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                                name
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo2.webp"
                                     srcset="images/brand_logo2.webp 1x,
												images/brand_logo2.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                                name
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="brand_block" href="">
                                <img src="images/brand_logo3.webp"
                                     srcset="images/brand_logo3.webp 1x,
												images/brand_logo3.webp 2x"
                                     alt=""
                                     title=""
                                     width="207"
                                     height="62"
                                />
                            name
                            </a>
                        </div>
                    </div>
                </div>
                <div class="about_section">
                    <div class="page_row">
                        <div class="left_block">
                            <div class="inner_sub">О нас</div>
                            <div class="block_title">Компания «Бехштейн» приветствует вас!</div>
                            <div class="description_block">
                                Марка C. Bechstein сегодня предстаёт в новом блеске! Фортепианная мануфактура C.
                                Bechstein, немецкий производитель акустических пианино и роялей высочайшего качества,
                                была основана в 1853 году в Берлине. Нынешний ассортимент, который мы предлагаем
                                профессиональным пианистам, организациям и просто любителям музыки, рассчитан
                                практически на любой бюджет.
                            </div>
                            <a href="" class="primary_btn">все О нас</a>
                        </div>
                        <div class="right_block">
                            <picture>
                                <source srcset="images/about.webp 1x, images/about.webp 2x">
                                <img src="images/about.webp" srcset="images/about.webp 1x, images/about.webp 2x" alt="" title="" width="732" height="866"/>
                            </picture>
                            <div class="small_img"><img src="images/aboutSmall.webp" title="" alt="" width="366" height="176"/></div>
                        </div>
                    </div>
                </div>
                <div class="services_section">
                    <div class="section_head">
                        <h2 class="section_title">Сервисы</h2>
                        <a href="" class="view_more">просмотреть все</a>
                    </div>
                    <div class="services_slider">
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Справочник по фортепиано</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Обслуживание и уход</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Гарантия обслуживания</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Академия для настройщиков</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Справочник по фортепиано</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Обслуживание и уход</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Гарантия обслуживания</span>
                            </a>
                        </div>
                        <div class="slide_block">
                            <a class="services_block" href="">
                                <img src="images/services.webp"
                                     srcset="images/services.webp 1x,
												images/services.webp 2x"
                                     alt=""
                                     title=""
                                     width="156"
                                     height="156"
                                />
                                <span class="services_name">Академия для настройщиков</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'templates/footer.php'
    ?>
</div>

<script src="js/jquery-3.7.1.min.js"></script>
<script src="js/slick.js"></script>
<script src="js/magentoMenu.js"></script>
<script src="js/main.js"></script>
</body>
</html>