function attachFile($attachField) {
    let attachError, attachedBlock, attachName = null;

    $attachField.on('change',(e) => {
        let $this = $(e.currentTarget);
        let fileSize = $this[0].files[0].size;
        let fileMaxSize = $attachField.data('maxsize') ? $attachField.data('maxsize')*1024*1024 : null;	
        let formats = $this.attr('accept') ? $this.attr('accept').toString() : null;		
        let fullPath = $this.val();
        let fileType = fullPath.substr(fullPath.lastIndexOf('.')).toLowerCase();
        $attachField.parents('.field').removeClass('has-error');
        if (fileMaxSize && fileSize > fileMaxSize) {
            if(!attachError) {
                $attachField.parents('.field').append('<span class="attach_error"></span>');
                attachError = $attachField.parents('.field').find('.attach_error');
            };
            attachError.text($attachField.data('sizeerror'));
            $attachField.val('');
            $attachField.parents('.field').find('.attached_file').remove();
            attachedBlock = null;
        } else if (formats && !formats.includes(fileType)){
            if(!attachError) {
                $attachField.parents('.field').append('<span class="attach_error"></span>');
                attachError = $attachField.parents('.field').find('.attach_error');
            };
            attachError.text($attachField.data('typeerror'));
            $attachField.val('');
            $attachField.parents('.field').find('.attached_file').remove();
            attachedBlock = null;

        } else {
            if (fullPath) {
                if(attachError) {
                    $(attachError).remove();
                    attachError = null;
                }
                
                let startIndex = (fullPath.indexOf('\\') >= 0 ? fullPath.lastIndexOf('\\') : fullPath.lastIndexOf('/'));
                let filename = fullPath.substring(startIndex);
                if (filename.indexOf('\\') === 0 || filename.indexOf('/') === 0) {
                    filename = filename.substring(1);
                }
                if(!attachedBlock) {
                    $attachField.parents('.field').append('<div class="attached_file"><div class="file_name"></div><span class="attach_remove"></span></div>');
                    attachedBlock = $attachField.parents('.field').find('.attached_file');
                    attachName = attachedBlock.find('.file_name');
                }
                attachName.text(filename);
                $attachField.attr('hidden','hidden');
            };
        }
        
    })
	
    $(document).on('click','.attach_remove',(e) => {
        $(e.target).parents('.field').find('input').val('').removeAttr('hidden');
        $(attachedBlock).remove();
        attachedBlock = null;
    })
}