const activateMenu = () => {
	const $mobileSize = 768;

	const isTouchDevice = () => 'ontouchstart' in document.documentElement;

	const closeAllMenus = (evt) => {
		if (!$(evt.target).closest('.main_menu, .menu_btn').length) {
			$('.main_menu li').removeClass('opened');
			$('.submenu_list').fadeOut(300);
			$('body').removeClass('menu_opened');
		}
	};

	const mobMenuTrigger = (e) => {
		e.preventDefault();
		if ($('body').hasClass('menu_opened')) {
			$('body').removeClass('menu_opened');
		} else {
			$('.main_menu li').removeClass('opened');
			$('.submenu_list').hide();
			$('.menu_inner, body, html').animate({ scrollTop: 0 }, 0);
			$('body').addClass('menu_opened');
		}
	};

	const openSubWithClick = (evt) => {
		evt.preventDefault();
		const $this = $(evt.currentTarget);
		if (isTouchDevice() && window.innerWidth >= $mobileSize) {
			if ($('.main_menu .opened').length < 1) closeAllMenus(evt);
			evt.stopPropagation();
			if ($this.closest('li').hasClass('opened')) {
				$this.closest('li').removeClass('opened').children('.submenu_list').slideUp(300);
			} else {
				$this.closest('ul').find('.opened').removeClass('opened');
				$this.closest('ul').find('.submenu_list').fadeOut(300);
				$this.closest('li').addClass('opened').children('.submenu_list').stop(true, true).slideDown(300);
			}
		} else if (window.innerWidth < $mobileSize) {
			if ($this.closest('li').hasClass('opened')) {
				$this.closest('li').removeClass('opened').children('.submenu_list').slideUp(300);
			} else {
				$this.closest('ul').find('.opened').removeClass('opened');
				$this.closest('ul').find('.submenu_list').slideUp(300);
				$this.closest('li').addClass('opened').children('.submenu_list').stop(true, true).slideDown(300);
			}
		}
	};

	const openSubWithHover = (e) => {
		if (!isTouchDevice() && window.innerWidth > $mobileSize) {
			const $item = $(e.currentTarget).parents('li');
			$item.addClass('hovered');
			setTimeout(() => {
				if ($item.hasClass('hovered')) {
					$item.addClass('opened').children('.submenu_list').stop(true, true).slideDown(300);
				}
			}, 300);
		}
	};

	const mouseLeaveItem = (e) => {
		$(e.currentTarget).parents('li').removeClass('hovered');
	};

	const closeSubWithHover = (e) => {
		if (!isTouchDevice()) {
			$(e.currentTarget).removeClass('opened').children('.submenu_list').fadeOut(300);
		}
	};

	// Attach event listeners
	$('.menu_btn').click(mobMenuTrigger);
	$('.header .submenu_btn').hover(openSubWithHover, mouseLeaveItem);
	$('.header .main_menu li').hover(() => {}, closeSubWithHover);
	$('.header .submenu_btn').click(openSubWithClick);

	// Attach event listener for outside click
	if (isTouchDevice()) {
		$(document).on('click touchstart', closeAllMenus);
	}
};
