let $mobileSize = 768;
let passConfirm = null;
let delayTime = null;

const isTouchDevice = () => {
    return 'ontouchstart' in document.documentElement;
};

const detectDevice = () => {
    if (navigator.userAgent.search("Safari") >= 0 && navigator.userAgent.search("Chrome") < 0) {
        $('body').addClass('ios_device');
    } else if (navigator.userAgent.search("Mozilla") >= 0 && navigator.userAgent.search("Chrome") < 0) {
        $('body').classList.add('moz');
    }
    ;
    if (isTouchDevice()) {
        $('html').addClass('touch');
        let standardMeta = "width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover";
        let specialMeta = "width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0, viewport-fit=cover";
        if ($('body').hasClass('ios_device')) {
            $('meta[name="viewport"]').attr('content', specialMeta);
            // $('input, textarea').on('touchstart', () => {
            //     $('meta[name="viewport"]').attr('content', specialMeta);
            //
            // });
            // $('input, textarea').blur(() => {
            //     $('meta[name="viewport"]').attr('content', standardMeta);
            // })
        }
    } else {
        $('html').addClass('web');
    }
}

const closeAllMenues = (evt) => {
    detectDevice();

    $('.drop_btn').parent().removeClass('opened');
    $('.drop_block').slideUp(300);

    if ($('.search_block').data('type') && $('.search_block').data('type') == 'close') {
        $('.search_block').removeClass('opened');
    }
}

const ignorBodyClick = (evt) => {
    evt.stopPropagation();
}

const ignorMobileBodyClick = (evt) => {
    if (window.innerWidth <= $mobileSize) {
        evt.stopPropagation();
    }
}

const dropList = (dropButton, dropList, dropItem, dropElement) => {
    if (dropButton.parents(dropItem).hasClass('opened')) {
        dropButton.parents(dropItem).removeClass('opened').find(dropElement).slideUp(300);
    } else {
        dropButton.parents(dropList).find('.opened').removeClass('opened');
        dropButton.parents(dropList).find(dropElement).slideUp(300);
        dropButton.parents(dropItem).addClass('opened').find(dropElement).stop(true, true).slideDown(300);
        setTimeout(() => {
            if ($(dropList).find('.opened').length > 0) {
                if (dropButton.parents(dropItem).offset().top < $(document).scrollTop()) {
                    $('body,html').animate({scrollTop: dropButton.parents(dropItem).offset().top}, 300);
                }
            }
        }, 300)
    }

};

const mobMenuTrigger = (e) => {
    e.preventDefault();
    if ($('body').hasClass('menu_opened')) {
        $('body').removeClass('menu_opened');
    } else {
        $('.menu_inner, .menu_list, .submenu_list').animate({scrollTop: 0}, 0);
        $('body').addClass('menu_opened').removeClass('sign_opened');
        $('.minicart-wrapper, .action.showcart, .switcher-options, .switcher-trigger').removeClass('active');
        if (window.innerWidth > 1024) {
            if ($('.catalog_menu .category_image').length < 1) {

                $('.menu_list > li').each((i, item) => {
                    let imageUrl = $(item).data('image');
                    let itemKey = $(item).data('sub');
                    $('.catalog_menu').append(`<span class="category_image" style="background-image: url('${imageUrl}')" data-sub="${itemKey}"></span>`)
                })

            }
            if ($('.menu_list li.opened').length < 1) {
                $('.menu_list > li:first-child').addClass('opened');
                let dataSub = $('.menu_list > li:first-child').attr('data-sub');
                $('.submenu_list[data-sub="' + dataSub + '"]').show();
                $('.category_image[data-sub="' + dataSub + '"]').addClass('showed');
            }

        } else {
            $('.menu_list li').removeClass('opened');
            $('.submenu_list').hide().removeClass('opened fixed').find('.back_btn').remove();
            $('.menu_block').removeClass('no_scroll')
        }
    }
}

const detectContentHeight = () => {
    let footerHeight = $('.page-footer').length > 0 ? $('.page-footer').innerHeight() : 0;
    let copyrightHeight = $('small.copyright').length > 0 ? $('small.copyright').innerHeight() : 0;
    let headerHeight = $('.page-header').length > 0 ? $('.page-header').innerHeight() : 0;
    let freeSpace = window.innerHeight - footerHeight - headerHeight - copyrightHeight;
    if (freeSpace > 0) {
        $('main.page-main').css('min-height', freeSpace);
    } else {
        $('main.page-main').css('min-height', 0);
    }
    ;
    $('.page-footer, small.copyright').css('opacity', 1);
}

const checkFields = () => {
    $(document).on('change', 'form input', (e) => {
        let $this = $(e.target);
        if ($this.val().length > 0) {
            $this.parents('.field_block').addClass('filled').find('.individual_hint').show();
            $this.parents('.field_block').find('.standard_hint').hide();
        } else {
            $this.parents('.field_block').removeClass('filled').find('.individual_hint').hide();
            $this.parents('.field_block').find('.standard_hint').show();
        }
        ;

    }).trigger('change');
}

const dropToggle = (evt) => {
    evt.preventDefault();
    let $this = $(evt.currentTarget);
    if (!$this.parent().hasClass('opened')) {
        closeAllMenues(evt);
        evt.stopPropagation();
        $this.parent().addClass('opened').find('.drop_block').stop(true, true).slideDown(300);
    }
};

const detectCallPosibillity = () => {
    if (/Android|iPhone|iPad|iPod|BlackBerry|BB|PlayBook|IEMobile|Windows Phone|Kindle|Silk|Opera Mini/i.test(navigator.userAgent)) {
        $('.phone_link').addClass('clickable');
    }
    $('.phone_link').click((e) => {
        if (!$(e.currentTarget).hasClass('clickable')) {
            e.preventDefault();
        }
    })
}

const changeCount = (countBlock, decreaseBtn, increaseBtn, countInput) => {

    $(countInput).each((i, item) => {
        let maxValue = $(item).data('max') ? $(item).data('max') : Math.pow(10, $(item).attr('maxlength')) - 1;
        if ($(item).val() == 1) {
            $(item).parents(countBlock).find(decreaseBtn).addClass('inactive');
        } else if ($(item).val() == maxValue) {
            $(item).parents(countBlock).find(increaseBtn).addClass('inactive');
        }
    });

    $(document).on('change', countInput, (e) => {
        let $this = $(e.currentTarget);
        let thisDecrease = $this.parents(countBlock).find(decreaseBtn);
        let thisIncrease = $this.parents(countBlock).find(increaseBtn);
        let maxValue = $this.data('max') ? $this.data('max') : Math.pow(10, $this.attr('maxlength')) - 1;
        if ($this.val() <= 1) {
            $this.val(1);
            thisDecrease.addClass('inactive');
            thisIncrease.removeClass('inactive');
        } else if ($this.val() >= maxValue) {
            $this.val(maxValue);
            thisIncrease.addClass('inactive');
            thisDecrease.removeClass('inactive');
        } else {
            thisIncrease.removeClass('inactive');
            thisDecrease.removeClass('inactive');
        }
    })

    $(document).on('click', decreaseBtn, (e) => {
        let $this = $(e.currentTarget);
        let thisInput = $this.parent().find('input');
        let thisIncrease = $this.parent().find(increaseBtn);
        let _value = thisInput.val();
        thisIncrease.removeClass('inactive');
        if (_value > 1) {
            _value--;
            thisInput.val(_value);
        }
        if (_value == 1) {
            $this.addClass('inactive');
        }
    });

    $(document).on('click', increaseBtn, (e) => {
        let $this = $(e.currentTarget);
        let thisInput = $this.parent().find('input');
        let thisDecrease = $this.parent().find(decreaseBtn);
        let _value = thisInput.val();
        let maxValue = thisInput.data('max') ? thisInput.data('max') : Math.pow(10, thisInput.attr('maxlength')) - 1;
        thisDecrease.removeClass('inactive');
        if (_value < maxValue) {
            _value++;
            thisInput.val(_value);
        }
        if (_value == maxValue) {
            $this.addClass('inactive');
        }
    });
}

function initSlider($el, $opts) {
    $el.slick($opts);
}

function activateMainSlider() {
    let autoPlaySpeed = 5000;
    let $slider = $('.main_slider .slider_inner');
    let $slide = $('.main_slider .slide_block');

    let $animation = {
        '-o-transition': 'width ' + autoPlaySpeed + 'ms linear',
        '-ms-transition': 'width ' + autoPlaySpeed + 'ms linear',
        '-moz-transition': 'width ' + autoPlaySpeed + 'ms linear',
        '-webkit-transition': 'width ' + autoPlaySpeed + 'ms linear',
        'transition': 'width ' + autoPlaySpeed + 'ms linear',
        width: '100%',
    };

    let $nonAnimation = {
        '-o-transition': 'none',
        '-ms-transition': 'none',
        '-moz-transition': 'none',
        '-webkit-transition': 'none',
        'transition': 'none',
        width: 0,
    };

    let mainSliderOpts = {
        fade: true,
        autoplay: true,
        autoplaySpeed: autoPlaySpeed,
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        dots: false,
        arrows: true,
    };

    let slidesCount = $slide.length;
    $('.slides_count').text(slidesCount);
    $slider.on('init', function (slick) {
        $('.slider_indicator .indicator_line').css($animation);
    });

    initSlider($slider, mainSliderOpts);
    $slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
        let activeNum = +nextSlide + 1;
        $('.current_slide').text(activeNum);
        $('.slider_indicator .indicator_line').css($nonAnimation);

    });

    $slider.on('afterChange', function () {
        $('.slider_indicator .indicator_line').css($animation);
    })
}

const initProductSlider = ($slider) => {
    $slider.slick({
        slidesToShow: 4,
        infinite: false,
        responsive: [
            {
                breakpoint: 1366,
                settings: {
                    slidesToShow: 3.1,
                }

            },
            {
                breakpoint: 1025,
                settings: {
                    arrows: false,
                    slidesToShow: 2.1,
                }

            },

            {
                breakpoint: 630,
                settings: {
                    arrows: false,
                    slidesToShow: 1.1,
                }
            }
        ]
    })
};

const initBrandsSlider = ($slider) => {
    $slider.slick({
        slidesToShow: 4,
        infinite: false,
        responsive: [
            {
                breakpoint: 1281,
                settings: {
                    slidesToShow: 4,
                }

            },
            {
                breakpoint: 1025,
                settings: {
                    arrows: false,
                    slidesToShow: 3,
                }
            },

            {
                breakpoint: 768,
                settings: {
                    arrows: false,
                    slidesToShow: 2,
                }
            }
        ]
    })
}

const initServicesSlider = ($slider) => {
    $slider.slick({
        slidesToShow: 4,
        infinite: false,
        responsive: [
            {
                breakpoint: 1366,
                settings: {
                    slidesToShow: 3.1,
                }

            },
            {
                breakpoint: 1025,
                settings: {
                    arrows: false,
                    slidesToShow: 2.1
                }

            },

            {
                breakpoint: 630,
                settings: {
                    arrows: false,
                    slidesToShow: 1.1,
                }
            }
        ]
    })
}

const initHistorySlider = ($slider) => {
    $slider.slick({
        slidesToShow: 3,
        infinite: false,
        autoplay: true,
        responsive: [
            {
                breakpoint: 1366,
                settings: {
                    slidesToShow: 2.3,
                }

            },
            {
                breakpoint: 1025,
                settings: {
                    arrows: false,
                    slidesToShow: 2
                }

            },

            {
                breakpoint: 768,
                settings: {
                    arrows: false,
                    slidesToShow: 1,
                }
            }
        ]
    })
}

const initRangeSlider = ($slider, $minInput, $maxInput) => {
    let $rangeMin = $slider.data('min');
    let $rangeMax = $slider.data('max');
    $minInput.val($rangeMin);
    $maxInput.val($rangeMax);
    $slider.slider({
        range: true,
        min: $rangeMin,
        max: $rangeMax,
        values: [$rangeMin, $rangeMax],
        slide: (event, ui) => {
            $minInput.val(ui.values[0]);
            $maxInput.val(ui.values[1])
        }
    });

    $minInput.on('keyup', (e) => {
        $minInput.val($minInput.val());
        let $newMin = parseInt($minInput.val());
        let $newMax = parseInt($maxInput.val());
        if ($newMin >= $rangeMin && $newMin <= $newMax) {
            $slider.slider('values', [$newMin, $newMax]);
        }
    });

    $minInput.on('change', (e) => {
        let $newMin = parseInt($minInput.val());
        let $newMax = parseInt($maxInput.val());
        if ($newMin >= $rangeMin && $newMin <= $newMax) {
            $slider.slider('values', [$newMin, $newMax]);
        } else if ($newMin < $rangeMin) {
            $slider.slider('values', [$rangeMin, $newMax]);
            $minInput.val($rangeMin);
        } else {
            $slider.slider('values', [$newMax, $newMax]);
            $minInput.val($rangeMax);
        }
    });

    $maxInput.on('keyup', (e) => {
        $maxInput.val($maxInput.val());
        let $newMin = parseInt($minInput.val());
        let $newMax = parseInt($maxInput.val());
        if ($newMax >= $newMin && $newMax <= $rangeMax) {
            $slider.slider('values', [$newMin, $newMax]);
        }
    });

    $maxInput.on('change', (e) => {
        let $newMin = parseInt($minInput.val());
        let $newMax = parseInt($maxInput.val());
        if ($newMax >= $newMin && $newMax <= $rangeMax) {
            $slider.slider('values', [$newMin, $newMax]);
        } else if ($newMax > $rangeMax) {
            $slider.slider('values', [$newMin, $rangeMax]);
            $maxInput.val($rangeMax)
        } else {
            $slider.slider('values', [$newMin, $newMin]);
            $maxInput.val($newMin);
        }
    });
}

const filterBlock = () => {
    const filterCurrentHTML = $('.filter-current').html();
    const blockActionsHTML = $('.block-actions').html();

    if (filterCurrentHTML || blockActionsHTML) {
        const combinedHTML = `
            <div class="filter_section">
                ${filterCurrentHTML ? `<div class="filter-current">${filterCurrentHTML}</div>` : ''}
                ${blockActionsHTML ? `<div class="block-actions">${blockActionsHTML}</div>` : ''}
            </div>
        `;

        $('.page-title-wrapper').append(combinedHTML);
    }
};

const handleResize = () => {
    const $filterSection = $('.filter_section');

    if (window.innerWidth <= 1024) {
        if (!$('.sidebar-main .filter_section').length) {
            $filterSection.appendTo('.sidebar-main');
        }
    } else {
        if (!$('.page-title-wrapper .filter_section').length) {
            $filterSection.appendTo('.page-title-wrapper');
        }
    }
};

const callSelect = ($select) => {
    $select.each((i, select) => {
        let selectParent = $(select).parent();
        let noResult = $(select).data('noresult') ? $(select).data('noresult') : 'Nothing found';
        if (!$(select).is(':hidden')) {
            $(select).select2({
                minimumResultsForSearch: 20,
                width: '100%',
                dropdownParent: selectParent,
                "language": {
                    "noResults": function () {
                        return noResult;
                    }
                },
            })
        }

    })
}


$(document).ready(() => {

    //detect device type
    detectDevice();
    detectCallPosibillity();

    const $header = $('body');
    const $social_fix = $('.social_fix');
    const $widgetBlock = $('.widget.block.block-static-block');
    const $pageFooter = $('.page-footer');

    $(window).on('scroll', () => {
        const widgetOffsetTop = $widgetBlock.offset().top + $widgetBlock.outerHeight() - 45;
        const scrollTop = $(window).scrollTop();
        const windowHeight = $(window).height();
        const footerOffsetTop = $pageFooter.offset().top;

        if (scrollTop > widgetOffsetTop) {
            $header.addClass('fix-header');
        } else {
            $header.removeClass('fix-header');
        }

        if (scrollTop + windowHeight >= footerOffsetTop) {
            $social_fix.addClass('close_social');
        } else {
            $social_fix.removeClass('close_social');
        }
    });


    if ($('.main_slider').length > 0) {
        activateMainSlider();
    }

    if ($('.filter-current').length > 0) {
        filterBlock();
        handleResize();
    }

    //close dropdowns with outside click
    $('body').click(closeAllMenues);

    if ($('.menu_block').length > 0) {
        activateMenu();
    }

    if ($('.page-wrapper select').length > 0) {
        callSelect($('.page-wrapper select'));
    }

    //drop element open close
    $('.drop_btn').click(dropToggle);

    //range slider init and sync with inputs
    if ($('.slider-range').length > 0) {
        initRangeSlider($('.slider-range'), $('.min_input'), $('.max_input'));
    }

    if ($('.about_page .about_text').length > 0) {
        let content = $('.about_text');
        let currentState = content.attr('data-show');
        let currentStateClose = content.attr('data-close');
        let height = $('.about_text .inner_block').height();

        if (height > 180) {

            let button = $('<button></button>')
                .text(currentState)
                .addClass('btn_more')
                .attr('title', currentState);

            content.append(button);

            content.on('click', '.btn_more', function () {
                if (content.hasClass('show_description')) {
                    content.removeClass('show_description');
                    $(this).text(currentState).attr('title', currentState);
                } else {
                    content.addClass('show_description');
                    $(this).text(currentStateClose).attr('title', currentStateClose);
                }
            });
        }
    }

    if ($('.details_list').length > 0) {
        $('.details_list .detail_name').click(function () {
            dropList($(this), $('.details_list .details_block > ul'), 'li', '.detail_unit');
        })
    }

    if ($('.page.messages').length > 0) {
        setTimeout(function () {
            $('.page.messages').hide();
        }, 5000)
    }

    if ($(".select_hash").length > 0) {
        $(".select_hash").select2();
        if (window.location.hash === "#ask") {
            const current_value =  $(".select_hash option:nth-child(4)").attr('value');
            $(".select_hash").val(current_value).trigger("change");
        }
    }

});

const animateSections = () => {
    $(window).on('scroll', () => {
        let scrollSize = $(document).scrollTop();

        if ($('.products_slider').length > 0 && $('.products_slider').length > $('.products_slider.slick-slider').length) {
            $('.products_slider:not(.slick-slider)').each((i, slider) => {
                if (scrollSize + window.innerHeight >= $(slider).offset().top + $(slider).innerHeight() / 2) {
                    initProductSlider($(slider));
                }
            })
        }

        if ($('.brands_slider').length > 0 && !$('.brands_slider').hasClass('slick-slider') && scrollSize + window.innerHeight >= $('.brands_slider').offset().top + $('.brands_slider').innerHeight() / 2) {
            initBrandsSlider($('.brands_slider'));
        }

        if ($('.services_slider').length > 0 && !$('.services_slider').hasClass('slick-slider') && scrollSize + window.innerHeight >= $('.services_slider').offset().top + $('.services_slider').innerHeight() / 2) {
            initServicesSlider($('.services_slider'));
        }

        if ($('.history_slider').length > 0 && !$('.history_slider').hasClass('slick-slider') && scrollSize + window.innerHeight >= $('.history_slider').offset().top + $('.history_slider').innerHeight() / 2) {
            initHistorySlider($('.history_slider'));
        }

    }).trigger('scroll');


};


$(window).on('load', () => {

    $(window).resize(() => {
        detectContentHeight();
        handleResize();

    }).trigger('resize');

    $('body').addClass('loaded');

    setTimeout(() => {
        $('.page_loader').remove();

        setTimeout(() => {
            animateSections();

        }, 200);

    }, 500);

});