<!DOCTYPE HTML>
<html lang="hy">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <meta name="format-detection" content="telephone=no"/>
    <meta name="description" content="Forte Piano">
    <title>Forte Piano</title>
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/product/product.css">
    <link rel="stylesheet" media="screen and (min-width: 1025px)" href="css/product/product-l.css">
    <link rel="stylesheet" media="screen and (max-width: 1024px)" href="css/product/product-m.css">
    <?php
    include 'templates/favicons.php'
    ?>
</head>
<body>
<div class="page-wrapper">
    <?php
    include 'templates/header.php'
    ?>

    <div class="breadcrumbs">
        <a href="" class="back_btn icon_left">Concert D 282</a>
        <ul class="items">
            <li class="item home">
                <a href="index.php">главная страница</a>
            </li>
            <li class="item category">
                <a href="listing.php"> Топ продукция</a>
            </li>
            <li class="item product">
                <strong>Concert D 282</strong>
            </li>
        </ul>
    </div>
    <main id="maincontent" class="page-main">
        <a id="contentarea" tabindex="-1"></a>
        <div class="page messages"><div data-placeholder="messages"></div>
            <div data-bind="scope: 'messages'">
                <!-- ko if: cookieMessagesObservable() && cookieMessagesObservable().length > 0 -->
                <div aria-atomic="true" role="alert" class="messages" data-bind="foreach: {
        data: cookieMessagesObservable(), as: 'message'
    }">
                    <div data-bind="attr: {
            class: 'message-' + message.type + ' ' + message.type + ' message',
            'data-ui-id': 'message-' + message.type
        }" class="message-error error message" data-ui-id="message-error">
                        <div data-bind="html: $parent.prepareMessageForHtml(message.text)">cannot connect to host; error = stream_socket_client(): Unable to connect to ssl://smtp.mail.ru:465 (php_network_getaddresses: getaddrinfo for smtp.mail.ru failed: Try again) (errno = 0 )</div>
                    </div>
                </div>
                <!-- /ko -->

                <div aria-atomic="true" role="alert" class="messages" data-bind="foreach: {
        data: messages().messages, as: 'message'
    }, afterRender: purgeMessages"></div>
            </div>


        </div>
        <div class="columns">
            <div class="column main">
                <div class="product_section">
                    <div class="product-info-main">
                        <div class="page-title-wrapper product">
                            <h1 class="page-title">
                                <span class="base">Concert D 282</span>
                            </h1>
                            <div class="product-info-stock-sku">
                                <div class="stock available">
                                    <span>Առկա է</span>
                                </div>

                            </div>

                        </div>
                        <div class="category">Рояль</div>
                        <div class="value description_block">
                            Рояль, о котором можно говорить только в превосходной степени. Фантастическое звучание,
                            идеальные исполнительские свойства.
                        </div>
                        <div class="additional-attributes-wrapper table-wrapper">
                            <table class="data table additional-attributes" id="product-attribute-specs-table">
                                <caption class="table-caption">More Information</caption>
                                <tbody>
                                <tr>
                                    <th class="col label" scope="row">Ապրանքանիշը</th>
                                    <td class="col data icon_bluetooth" data-th="Ապրանքանիշը">Данный акустический
                                        инструмент поддерживает Bluetooth MIDI.
                                        <div class="field-tooltip toggle">
                                            <span class="label"><span>հուշում</span></span>
                                            <span class="field-tooltip-action action-help"></span>
                                            <div class="field-tooltip-content" data-target="dropdown">Our instruments that leave our factory from 01.11.2023 include C. Bechstein Connect. Thanks to Bluetooth MIDI, this opens the door to a limitless world of creative apps.
                                                <a href="" class="more_btn">More information</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="col label" scope="row">Ծավալը</th>
                                    <td class="col data icon_headphones" data-th="Ծավալը">по дополнительному заказу: <a
                                                href="">Система C. Bechstein Vario</a>
                                        <div class="field-tooltip toggle">
                                            <span class="label"><span>հուշում</span></span>
                                            <span class="field-tooltip-action action-help"></span>
                                            <div class="field-tooltip-content" data-target="dropdown">Our instruments that leave our factory from 01.11.2023 include C. Bechstein Connect. Thanks to Bluetooth MIDI, this opens the door to a limitless world of creative apps.

                                            </div>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="product-info-price">
                            <div class="price-box price-final_price">
									<span class="normal-price">
										<span class="price-container price-final_price tax weee">
											<span class="price-label">As low as</span>
											<span class="price-wrapper">
												<span class="price">2 000 000 &#1423;</span>
											</span>
										</span>
									</span>
                            </div>
                        </div>
                        <div class="product-add-form">
                            <form id="product_addtocart_form">
                                <div class="product-options-wrapper">
                                    <div class="fieldset">
                                        <div class="swatch-opt">
                                            <div class="swatch-attribute color">
                                                <span class="swatch-attribute-label">Գույն</span>
                                                <span class="swatch-attribute-selected-option"></span>
                                                <div class="swatch-attribute-options clearfix">
                                                    <div class="swatch-option color"
                                                         style="background: #53a828 no-repeat center; background-size: initial;"></div>
                                                    <div class="swatch-option color"
                                                         style="background: #eb6703 no-repeat center; background-size: initial;"></div>
                                                    <div class="swatch-option color"
                                                         style="background: #ef3dff no-repeat center; background-size: initial;"></div>
                                                </div>
                                                <input class="swatch-input super-attribute-select"
                                                       name="super_attribute[93]" type="text" value=""
                                                       data-selector="super_attribute[93]"
                                                       data-validate="{required: true}"
                                                       aria-required="true" aria-invalid="false">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-options-bottom">
                                    <div class="box-tocart">
                                        <div class="fieldset">
                                            <div class="actions">
                                                <button type="submit" title="Add to Cart" class="icon_location action primary tocart"
                                                        id="product-addtocart-button">
                                                    <span>Адреса официальных дилеров</span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="product media">
                        <a id="gallery-prev-area" tabindex="-1"></a>
                        <div class="action-skip-wrapper">
                            <a class="action skip gallery-next-area" href="#gallery-next-area">
                                <span>Skip to the end of the images gallery </span>
                            </a>
                        </div>
                        <span class="stickers">
                            <span class="new_sticker">Новый</span>
                        </span>
                        <div class="gallery-placeholder" data-gallery-role="gallery-placeholder">
                            <div class="fotorama--hidden"></div>
                            <style>
                                .fotorama__nav--thumbs .fotorama__nav__frame {
                                    padding: 2px;
                                    height: 120px
                                }

                                .fotorama__thumb-border {
                                    height: 120px;
                                    border-width: 2px;
                                    margin-top: 2px
                                }
                            </style>
                            <div class="fotorama-item fotorama">
                                <div data-gallery-role="fotorama__focusable-start" tabindex="-1"></div>
                                <div class="fotorama__wrap fotorama__wrap--css3 fotorama__wrap--slide fotorama__wrap--toggle-arrows fotorama__wrap--no-controls"
                                     style="min-width: 0px; max-width: 100%;">
                                    <div class="fotorama__stage" style="height: 513px; width: 532px;">
                                        <div class="fotorama__fullscreen-icon"></div>
                                        <div class="fotorama__arr fotorama__arr--prev">
                                            <div class="fotorama__arr__arr"></div>
                                        </div>
                                        <div class="fotorama__stage__shaft fotorama__grab"
                                             style="transition-duration: 0ms; transform: translate3d(0px, 0px, 0px); margin-left: 0px; width: 606px;">
                                            <div class="fotorama__stage__frame fotorama__active fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img"
                                                 style="left: 0px;" href="images/product_image1.webp">
                                                <img src="images/product_image1.webp" alt="" title=""
                                                     class="fotorama__img--full"/>
                                                <img src="images/product_image1.webp" alt="" title=""
                                                     class="fotorama__img"/>
                                            </div>
                                            <div class="fotorama__stage__frame fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img"
                                                 style="left: -709px;" href="images/product_image1.webp">
                                                <img src="images/product_image1.webp" alt="" title=""
                                                     class="fotorama__img"/>
                                            </div>
                                            <div class="fotorama__stage__frame fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img"
                                                 style="left: 709px;" href="images/product_image1.webp">
                                                <img src="images/product_image1.webp" alt="" title=""
                                                     class="fotorama__img"/>
                                            </div>
                                        </div>
                                        <div class="fotorama__arr fotorama__arr--next">
                                            <div class="fotorama__arr__arr"></div>
                                        </div>
                                        <div class="fotorama__video-close"></div>
                                        <div class="fotorama__zoom-in zoom-in-loaded"></div>
                                        <div class="fotorama__zoom-out zoom-out-loaded"></div>
                                        <div class="fotorama__spinner"></div>
                                    </div>
                                    <div class="fotorama__nav-wrap fotorama__nav-wrap--horizontal">
                                        <div class="fotorama__nav fotorama__nav--thumbs"
                                             style="height: 100px; width: 707px;">
                                            <div class="fotorama__thumb__arr fotorama__thumb__arr--left fotorama__arr--disabled"
                                                 disabled="disabled">
                                                <div class="fotorama__thumb--icon"></div>
                                            </div>
                                            <div class="fotorama__nav__shaft"
                                                 style="transition-duration: 0ms; transform: translate3d(0px, 0px, 0px);">
                                                <div class="fotorama__thumb-border"
                                                     style="transition-duration: 0ms; transform: translate3d(0px, 0px, 0px); width: 100px; height: 120px;"></div>
                                                <div class="fotorama__nav__frame fotorama__nav__frame--thumb fotorama__active"
                                                     style="width: 100px;" data-active="true">
                                                    <div class="fotorama__thumb fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img">
                                                        <img src="images/product_image1.webp" alt="" title=""
                                                             class="fotorama__img"/>
                                                    </div>
                                                </div>
                                                <div class="fotorama__nav__frame fotorama__nav__frame--thumb"
                                                     style="width: 100px;">
                                                    <div class="fotorama__thumb fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img">
                                                        <img src="images/product_image1.webp" alt="" title=""
                                                             class="fotorama__img"/>
                                                    </div>
                                                </div>
                                                <div class="fotorama__nav__frame fotorama__nav__frame--thumb"
                                                     style="width: 100px;">
                                                    <div class="fotorama__thumb fotorama_vertical_ratio fotorama__loaded fotorama__loaded--img">
                                                        <img src="images/product_image1.webp" alt="" title=""
                                                             class="fotorama__img"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="fotorama__thumb__arr fotorama__thumb__arr--right fotorama__arr--disabled"
                                                 disabled="disabled">
                                                <div class="fotorama__thumb--icon"></div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div data-gallery-role="fotorama__focusable-end" tabindex="-1"></div>
                            </div>
                            <div class="magnifier-preview magnify-hidden" data-gallery-role="magnifier" id="preview"
                                 style="display: none;"></div>
                        </div>
                        <div class="action-skip-wrapper">
                            <a class="action skip gallery-prev-area" href="#gallery-prev-area">
                                <span>Skip to the beginning of the images gallery </span>
                            </a>
                        </div>
                        <a id="gallery-next-area" tabindex="-1"></a>
                    </div>
                </div>
                <div class="product info detailed">
                    <div class="product data items mage-tabs-disabled" role="tablist">
                        <div class="data item title" data-role="collapsible" id="tab-label-description" role="tab" data-collapsible="true" aria-controls="description" aria-selected="false" aria-expanded="false" tabindex="0">
                            <a class="data switch" tabindex="-1" data-toggle="trigger" href="#description" id="tab-label-description-title">
                                Մանրամասներ                    </a>
                        </div>
                        <div class="data item content" aria-labelledby="tab-label-description" id="description" data-role="content" role="tabpanel" aria-hidden="true" style="display: none;">

                            <div class="product attribute description">
                                <div class="value"><div data-content-type="html" data-appearance="default" data-element="main" data-decoded="true"><em><strong>C. Bechstein Academy շարքի ամենափոքր դաշնամուրը</strong></em></div>
                                    <div data-content-type="html" data-appearance="default" data-element="main" data-decoded="true">&nbsp;</div>
                                    <div style="line-height: 1.5;" data-content-type="html" data-appearance="default" data-element="main" data-decoded="true">Պրեմիում-դասի նրբագեղ գործիք, C. Bechstein Academy շարքի <strong>ամենափոքր</strong> դաշնամուրը, որի ձայնի լիարժեք ծավալը և կատարյալ բալանսը ապահովում է հիասքանչ փափուկ և բնական հնչողություն։ Չնայած իր փոքր չափերին, Academy A 2 մոդելի մեխանիկան հատուկ կատարելագործվել է իսկ ձայնը բարելավվել է հատուկ մանրակրկիտությամբ, ինչի շնորհիվ ապահովվում է ձայնային լայն դիապազոն՝ չափազանց նուրբ տոներից մինչև շատ հզորը:</div>
                                    <div style="line-height: 1.5;" data-content-type="html" data-appearance="default" data-element="main" data-decoded="true">&nbsp;</div>
                                    <div style="line-height: 1.5;" data-content-type="html" data-appearance="default" data-element="main" data-decoded="true"><em><strong>Չափազանց նուրբ տոներից մինչև շատ հզորը</strong></em></div>
                                    <div style="line-height: 1.5;" data-content-type="html" data-appearance="default" data-element="main" data-decoded="true">&nbsp;</div>
                                    <div style="line-height: 1.5;" data-content-type="html" data-appearance="default" data-element="main" data-decoded="true">Սաքսոնիայի Զայֆհեններսդորֆ քաղաքում գտնվող C. Bechstein-ի արտադրամասում դաշնամուրի փորձառու վարպետները ստեղծում են իսկական գլուխգործոցներ, որոնցից յուրաքանչյուրն օժտված է բացառիկ երաժշտական &ZeroWidthSpace;&ZeroWidthSpace;անհատականությամբ: Դաշնամուրի պատրաստման ավելի քան 170 տարվա փորձը շարունակականության և հուսալիության վառ վկայությունն է:</div></div>
                            </div>
                        </div>
                        <div class="data item title active" data-role="collapsible" id="tab-label-additional" role="tab" data-collapsible="true" aria-controls="additional" aria-selected="true" aria-expanded="true" tabindex="0">
                            <a class="data switch" tabindex="-1" data-toggle="trigger" href="#additional" id="tab-label-additional-title">
                                More Information                    </a>
                        </div>
                        <div class="data item content" aria-labelledby="tab-label-additional" id="additional" data-role="content" role="tabpanel" aria-hidden="false" style="display: block;">

                            <h2 class="section_title">Տեխնիկական բնութագրեր</h2>
                            <div class="details_list">
                                <div class="details_block">
                                    <ul>

                                        <li>
                                            <div class="detail_name">Աշխատանքային ժամերի քանակը</div>
                                            <div class="detail_unit">
                                                7 ամիս, 120 ժամ                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Ընդհանուր նկարագիր</div>
                                            <div class="detail_unit">
                                                Պրեմիում-դասի նրբագեղ գործիք:                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Ռեզոնանսային դեկայի փայտանյութը</div>
                                            <div class="detail_unit">
                                                Ռեզոնանսային դեկան պատրաստված է ծովի մակարդակից 800-1000 մ բարձրության վրա աճեցվող լեռնային եղևնուց։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Ռեզոնանսային դեկայի կառուցվածքը</div>
                                            <div class="detail_unit">
                                                Յուրաքանչյուր դեկա համապատասխանեցվում է կոնկրետ գործիքի ակուստիկ առանձնահատկություններին։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Ռեզոնատոր-իրան</div>
                                            <div class="detail_unit">
                                                Ռեզոնատոր-իրանը պատրաստված է եղևնու, հաճարի և սոճու տեսակներից։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Չուգունե շրջանակ</div>
                                            <div class="detail_unit">
                                                Չուգունի յուրահատուկ բաղադրությունը և շրջանակի հատուկ ձևը թույլ են տալիս մարել վիբրացիաները, ուժեղացնում են բարձր հաճախային լարերի էներգիան և բարելավում փոխանցման արագությունը։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">C. Bechstein կամրջակի կալիբրման համակարգ (ԿԿՀ)</div>
                                            <div class="detail_unit">
                                                Կամուրջները պատրաստված են գերմանական կարմիր հաճարից՝ օգտագործելով ժամանակակից թվային ծրագրավորման տեխնոլոգիաներ, ինչը երաշխավորում է ձայնի և հաճախականությունների կատարյալ փոխանցում դեկային:                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Վիրբելշտոկ</div>
                                            <div class="detail_unit">
                                                Մուլտիպլեքս պինդ փայտից:                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Ստեղնաշար</div>
                                            <div class="detail_unit">
                                                Ամուր, առաձգական ստեղնաշար՝ համերգային ելույթների համար իդեալական լծակների հարաբերակցությամբ։ Ստեղնաշարը հատուկ մշակված է C. Bechstein ընկերության հետազոտությունների և զարգացման բաժնի կողմից։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Մեխանիկա</div>
                                            <div class="detail_unit">
                                                C. Bechstein ընկերության կողմից մշակված չափազանց բարդ և չափազանց ճշգրիտ պրոֆեսիոնալ մեխանիկա, որը բաղկացած է 2000 դետալներից և մշակված է ստեղնաշարի երկրաչափության ստանդարտներին և C. Bechstein-ի մեխանիկային համապատասխան։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Մուրճիկների գլխիկները</div>
                                            <div class="detail_unit">
                                                Մուրճիկները պատրաստվում են կարմիր փայտից և  ծածկված են Գերմանիայում պատրաստված նորզելանդական բրդից՝ ավանդական, գաղտնի տեխնոլոգիայով, ապահովելով  համերգային չափանիշներով գերազանց դինամիկա և լավագույն նրբերանգներ:                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Մեխանիզմի կառուցվածքը – Ֆրիկցիայի կառավարման համակարգ (Friction control system)</div>
                                            <div class="detail_unit">
                                                Քաշի և շփման գործակիցների օպտիմալ արժեքներ, որոնք ապահովվում են նորագույն տեխնոլոգիաների կիրառման շնորհիվ։                            </div>
                                        </li>


                                        <li>
                                            <div class="detail_name">Իրանի երեսապատումը</div>
                                            <div class="detail_unit">
                                                Իրանը պատված է C. Bechstein-ի գործարանում մոտ քսան բարձրակարգ դետալներից, ծածկված է բարձրակարգ լաքով, ապահովելով կատարյալ փայլ և նրբագեղ ծածկույթ։                            </div>
                                        </li>
                                    </ul>     </div>
                                <div class="details_block">
                                    <table>
                                        <tbody><tr>
                                            <td>Թվային դաշնամուրներ</td>
                                            <td>Այո</td>
                                        </tr>


                                        <tr>
                                            <td>Բրենդ</td>
                                            <td>C. Bechstein Academy</td>
                                        </tr>


                                        <tr>
                                            <td>Մոդել</td>
                                            <td>Academy A 2</td>
                                        </tr>

                                        </tbody></table>     </div>
                            </div>
                        </div>
                        <script type="text/javascript">    var elemT3zFWHtzArray = document.querySelectorAll('#additional');
                            if(elemT3zFWHtzArray.length !== 'undefined'){
                                elemT3zFWHtzArray.forEach(function(element) {
                                    if (element) {
                                        element.style.display = 'none';

                                    }
                                });
                            }</script>                                                    </div>
                </div>                <span class="cb"></span>
                <div class="products_section">
                    <div class="section_head">
                        <h2 class="section_title">Топ продукция</h2>
                        <a href="listing.php" class="view_more">просмотреть все</a>
                    </div>
                    <div class="products_slider">
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                        <div class="slide_block">
                            <?php
                            include 'templates/block.php'
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php
    include 'templates/footer.php'
    ?>
</div>

<script src="js/jquery-3.7.1.min.js"></script>
<script src="js/slick.min.js"></script>
<script src="js/magentoMenu.js"></script>
<script src="js/main.js"></script>
</body>
</html>