<!DOCTYPE HTML>
<html lang="hy">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <meta name="format-detection" content="telephone=no"/>
    <meta name="description" content="some description about project">
    <title>Forte Piano</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="css/service/service.css">
    <link rel="stylesheet" media="screen and (min-width: 1025px)" href="css/service/service-l.css">
    <link rel="stylesheet" media="screen and (max-width: 1024px)" href="css/service/service-m.css">
    <?php
    include 'templates/favicons.php'
    ?>
</head>
<body>
<div class="page-wrapper">
    <?php
    include 'templates/header.php'
    ?>
    <div class="breadcrumbs">
        <a href="" class="back_btn icon_left">Обслуживание и уход</a>
        <ul class="items">
            <li class="item home">
                <a href="index.php" title="Go to Home Page">главная страница</a>
            </li>
            <li class="item home">
                <a href="index.php" title="Go to Home Page">Сервисы</a>
            </li>
            <li class="item">
                <strong>Обслуживание и уход</strong>
            </li>
        </ul>
    </div>
    <main id="maincontent" class="page-main">
        <div class="columns">
            <div class="column main">
                <div class="inner_page">
                    <div class="img_block">
                        <picture>
                            <source media="(min-width:1441px)" width="1920" height="1080" srcset="images/inner.webp 1x, images/inner@x2.webp 2x">
                            <source media="(min-width:1025px)" width="1440" height="810" srcset="images/inner.webp 1x, images/inner@x2.webp 2x">
                            <source media="(min-width:769px)" width="1024" height="576" srcset="images/inner.webp 1x, images/inner@x2.webp 2x">
                            <source media="(min-width:480px)" width="768" height="1024" srcset="images/inner@x2.webp">
                            <!--size x2-->
                            <img class="full_height" src="images/inner@x2.webp" width="360" height="640" alt="" title=""/> <!--size x2-->
                        </picture>
                    </div>
                    <div class="standard_textpage">
                        <h2>Обслуживание и уход</h2>
                        <p>
                            Ваш фирменный инструмент, выпущенный в компании «К. Бехштейн», изготовлен из преимущественно
                            натуральных материалов высочайшего качества, которые чувствительно реагируют на изменения
                            микроклимата. Это сказывается не только на звучании инструмента, но и на его механических
                            компонентах. Так, колебания влажности воздуха оказывают влияние на выпуклость деки и на силу
                            натяжения струн. Игровая нагрузка также влияет на характер звучания и механические
                            характеристики пианино/рояля.
                        </p>
                        <h3>Постоянное удовольствие от игры</h3>
                        <p>
                            Квалифицированное обслуживание позволяет сохранить качество звука и отличные игровые качества инструмента. Хорошо настроенный, отрегулированный и интонированный инструмент станет постоянным источником радости для исполнителя и слушателей.
                        </p>
                        <h3>Гарантированное качество при регулярном обслуживании</h3>
                        <p>
                            Наша прекрасно отлаженная система менеджмента качества (по методике «шесть сигм») и доля брака на производстве, составляющая не более 0,01 процента, позволяют нам без труда предоставлять на каждый фирменный инструмент пятилетнюю гарантию. Поэтому обязательно обращайте внимание на условия предоставления гарантийного ремонта, указанные в вашей гарантийной книжке.
                        </p>
                        <h3>Сохранение стоимости за счёт обслуживания </h3>
                        <p>
                            Регулярное обслуживание инструмента – его настройка, регулировка и интонировка – помогает сохранять стоимость вашего инструмента.
                            <br />
                            <br />
                            Обслуживание помогает оптимально отладить звучание, высоту и силу звуков, их тембра, отрегулировать механику, а также
                            <a href="">обеспечить уход за акустической системой и корпусом.</a>
                            <br />
                            <br />
                            Регулярное сервисное обслуживание силами наших официальных фортепианных мастеров – именно то, что нужно вашему инструменту! Так Вы сможете сохранить стоимость вашего инструмента – и получать удовольствие от игры. Как говорится, игра стоит свеч! 
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php
    include 'templates/footer.php'
    ?>
</div>

<script src="js/jquery-3.7.1.min.js"></script>
<script src="js/magentoMenu.js"></script>
<script src="js/main.js"></script>
</body>
</html>