<!DOCTYPE HTML>
<html lang="hy">
 	<head>
  		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
		<meta name="format-detection" content="telephone=no"/>
		<meta name="description" content="Digitain queue">
		
  		<title>Digitain queue</title>

		<link rel="stylesheet" href="css/intlTelInput.css">
		<link rel="stylesheet" href="css/home/index.css">
		<?php
			include 'templates/favicons.php'
		?>
 	</head>
 	<body>
		<div class="content">
			<div class="logo_block">
				<img src="css/images/main_logo.png" alt="digitian main logo" width="371" height="127"/>
			</div>
			<div class="first_screen">
				<div class="description_block">Your Success is our top priority. Discover 
					how our innovative solutions can drive 
					your business forward.
				</div>
				<div class="projects_list">
					<button type="button" data-value="sportsbook" aria-label="Sportsbook">Sportsbook</button>
					<button type="button" data-sub="centrive" aria-label="Centrive">Centrive</button>
					<button type="button" data-sub="paydrom" aria-label="Paydrom">Paydrom</button>
					<button type="button" data-value="virtual_sprots" aria-label="Virtual Sports">Virtual Sports</button>
					<button type="button" data-value="other" aria-label="Other">Other</button>
				</div>
				<div class="sub_projects" data-sub="centrive">
					<div class="project_name">Centrive</div>
					<div class="projects_list">
						<button type="button" data-value="centrive1" aria-label="Centrive 1">Centrive 1</button>
						<button type="button" data-value="centrive2" aria-label="Centrive 2">Centrive 2</button>
						<button type="button" data-value="centrive3" aria-label="Centrive 3">Centrive 3</button>
						<button type="button" data-value="centrive4" aria-label="Centrive 4">Centrive 4</button>
						<button type="button" data-value="centrive5" aria-label="Centrive 5">Centrive 5</button>
					</div>
				</div>
				<div class="sub_projects" data-sub="paydrom">
					<div class="project_name">Paydrom</div>
					<div class="projects_list">
						<button type="button" data-value="paydrom1" aria-label="paydrom 1">Paydrom 1</button>
						<button type="button" data-value="paydrom2" aria-label="paydrom 2">Paydrom 2</button>
						<button type="button" data-value="paydrom3" aria-label="paydrom 3">Paydrom 3</button>
						<button type="button" data-value="paydrom4" aria-label="paydrom 4">Paydrom 4</button>
						<button type="button" data-value="paydrom5" aria-label="paydrom 5">Paydrom 5</button>
					</div>
				</div>
				
			</div>
			
			<form class="submit_form">
				<input type="hidden" name="project" data-field="name"/>
				<div class="project_name">Sportsbook</div>
				<div class="field_block">
					<input type="text" name="email" placeholder="Input your email" maxlength="50" data-validation="email"/>
					<span class="error_hint">
						<span class="standard_hint">mandatory field</span>
						<span class="individual_hint">wrong email</span>
					</span>
				</div>
				<div class="field_block">
					<input type="text" name="phone" maxlength="15" data-validation="required" class="phone_input" oninput="this.value=this.value.replace(/[^0-9]/g,'');"/>
					<span class="error_hint">mandatory field</span>
				</div>
				<div class="field_block">
					<label class="check_btn">
						<input type="checkbox" name="agreement" data-validation="required"/>
						I agree to the processing of personal data*
					</label>
					<span class="error_hint">You must consent to the processing of personal data</span>
				</div>
				<button aria-label="Submit" data-submit="submit">Submit</button>
			</form>

			<!-- <span class="back_btn">Back</span> -->
		</div>
	
		
	 	<script src="js/intlTelInput.min.js"></script>
	 	<script type="module" src="js/main.js"></script>
		 <script>
			function submit(e, $form) {
				e.preventDefault();
				$form.querySelector('[data-submit]').classList.add('loading');
				//the backend code needs to be written here, instead of settimeout, after completion use the codes in setTimeout to reset the loader, form and call the message
				setTimeout(() => {
					//error
					// document.body.insertAdjacentHTML('beforeend', ` <div class="error_message">
					// 	<div class="error_text">Something went wrong, please, try again</div>
					// 	<span class="message_close"></span>
					// </div>`);
					// $form.querySelector('[data-submit]').classList.remove('loading');
					
					//success
					$form.remove();
					document.querySelector('.content').insertAdjacentHTML('beforeend', `
						<div class="ticket_block">
							<div class="ticket_label">It is your ticket number</div>
							<div class="ticket_number">A0057</div>
						</div> 
					`)
					document.querySelector('.back_btn').textContent = 'Go to home'
				},1500)
				
			}
		</script>
 	</body>
</html>