import { validateInputs } from "./validator.js";

const $body = document.body;
const $html = document.documentElement;

const $ = (element) => {
	return document.querySelector(element);
}

const $$ = (elements) => {
	return document.querySelectorAll(elements);
}

const checkFieldValue = ($field) => {
	if ($field.value) {
		$field.classList.add('filled')
		if( $field.closest('div').querySelectorAll('.individual_hint').length > 0) {
			$field.closest('div').querySelector('.individual_hint').style.display = 'block';
			$field.closest('div').querySelector('.standard_hint').style.display = 'none';
		}
		if($field.parentNode.classList.contains('error')) {
			validateInputs($field.closest('form'));
		}
		
	} else {
		$field.classList.remove('filled');
		if( $field.closest('div').querySelectorAll('.individual_hint').length > 0) {
			$field.closest('div').querySelector('.individual_hint').style.display = 'none';
			$field.closest('div').querySelector('.standard_hint').style.display = 'block';
		}
	};
}

const checkForm = ($formId) => {
	$$(`${$formId} .field_block`).forEach($block => {
		const $field = $block.querySelector('input') ? $block.querySelector('input') : $block.querySelector('textarea');
		checkFieldValue($field);
	});

	const $form = $($formId);
	
	$form.querySelectorAll('input').forEach($field => {
		checkFieldValue($field)
	});
	$form.addEventListener('submit', function(e) {
		const $btn = $form.querySelector('[data-submit]');
		const submitFunction = $btn.dataset.submit;
		const checkValid = validateInputs($form);
		e.preventDefault();
		if(checkValid){
			if (typeof window[submitFunction] === "function") {
				window[submitFunction](e, $form);  
			} 
			return false;
		}else{
			e.preventDefault();
		}
	});
}

export {
	$,
	$$,
	checkForm,
}