import { $, $$, checkForm } from "./imports/utils.js";

window.addEventListener('load', () => {
	if($$('.submit_form').length > 0) {
		if($('.phone_input')) {
			window.intlTelInput($('.phone_input'), {
				countrySearch: false,
				autoPlaceholder: true,
				initialCountry: 'es',
				separateDialCode: true,
				strictMode: true,
				loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.15.0/build/js/utils.js"),
			});
		}
		checkForm('.submit_form');
	}

	document.addEventListener('click', (e) => {
		if(e.target.classList.contains('message_close')) {
			e.target.closest('.error_message').remove();
		} else if (e.target.tagName === 'BUTTON' && e.target.closest('.projects_list')) {
			if(e.target.dataset.value) {
				const projectName = e.target.dataset.value;
				const projectCode = e.target.dataset.code;
				const projectSection = e.target.dataset.section;
				const nameText = e.target.textContent;
				$('.submit_form .project_name').textContent = nameText;
				$('[data-field="name"]').value = projectName;
				$('[data-field="code"]').value = projectCode;
				if (typeof projectSection !== 'undefined') {
					$('[data-field="section"]').value = projectSection;
				} 
				$('.submit_form').removeAttribute('hidden');
			} else if (e.target.dataset.sub) {
				$(`.sub_projects[data-sub="${e.target.dataset.sub}"]`).classList.add('showed');
			}
		} else if (e.target.classList.contains('back_btn')) {
			if($('.submit_form') && !$('.submit_form').hasAttribute('hidden')) {
				$('.submit_form').setAttribute('hidden', 'hidden')
			} else if($('.ticket_block')) {
				window.location.reload();
			} else {
				$(`.sub_projects.showed`).classList.remove('showed');
			}
			
		}
	})
})

